<?php
class CodigodeControl {
 
    static public $d = array(
        array(0,1,2,3,4,5,6,7,8,9),
        array(1,2,3,4,0,6,7,8,9,5),
        array(2,3,4,0,1,7,8,9,5,6),
        array(3,4,0,1,2,8,9,5,6,7),
        array(4,0,1,2,3,9,5,6,7,8),
        array(5,9,8,7,6,0,4,3,2,1),
        array(6,5,9,8,7,1,0,4,3,2),
        array(7,6,5,9,8,2,1,0,4,3),
        array(8,7,6,5,9,3,2,1,0,4),
        array(9,8,7,6,5,4,3,2,1,0)
    );
 
    static public $p = array(
        array(0,1,2,3,4,5,6,7,8,9),
        array(1,5,7,6,2,8,3,0,9,4),
        array(5,8,0,3,7,9,6,1,4,2),
        array(8,9,1,6,0,4,3,5,2,7),
        array(9,4,5,3,1,2,6,8,7,0),
        array(4,2,8,6,5,7,3,9,0,1),
        array(2,7,9,3,8,0,6,4,1,5),
        array(7,0,4,6,9,1,3,2,5,8)
    );
 
    static public $inv = array(0,4,3,2,1,5,6,7,8,9);
 
    static function verh($num) {
        if(!preg_match('/^[0-9]+$/', $num)) {
            throw new \InvalidArgumentException(sprintf("Error! Value is restricted to the number, %s is not a number.",
                                                    $num));
        }
 
        $r = 0;
        foreach(array_reverse(str_split($num)) as $n => $N) {
            $r = self::$d[$r][self::$p[($n+1)%8][$N]];
        }
        return self::$inv[$r];
    }
    function rellenar($n)
    {
        if(strlen($n)==1)
            $n="0".$n;
        return $n;
    }
    
    function nverh($valor,$cant)
    {
        $cont=1;
        $res="";
        
        while($cont<=$cant)
        {
            $res=$res.$this->verh($valor);
            $valor=$valor.$this->verh($valor);
            $cont++;
        }
        return $res;
    }
    function sumatoria($valor,$inicio,$incremento)
    {
        //ord($v);
        $cont=$inicio;
        $sum=0;
        while($cont<=strlen($valor))
         {
            $sum=$sum+ord(substr($valor,$cont-1, 1));
            $cont=$cont+$incremento;
         }
        
        return $sum;
    }
    function codigoControl($nroau,$nrofac,$nit,$fecha,$monto,$llave)
    {
        $fecha=str_replace('/', '', $fecha);
	$monto=round(str_replace(',', '.', $monto), 0);
        $suma=($nrofac.$this->nverh($nrofac,'2'))+($nit.$this->nverh($nit,'2'))+($fecha.$this->nverh($fecha,'2'))+($monto.$this->nverh($monto,'2'));
        
        $pas1=$this->nverh($suma,'5');
        $v1=substr($pas1, 0, 1)+1;
        $v2=substr($pas1,1, 1)+1;
        $v3=substr($pas1,2, 1)+1;
        $v4=substr($pas1,3, 1)+1;
        $v5=substr($pas1,4, 1)+1;
        $vl1=substr($llave,0, $v1);
        $vl2=substr($llave,$v1,$v2);
        $vl3=substr($llave,$v1+$v2,$v3);
        $vl4=substr($llave,$v1+$v2+$v3,$v4);
        $vl5=substr($llave,$v1+$v2+$v3+$v4,$v5);
        $vconau=$nroau.$vl1;
        $vconfac=$nrofac.$this->nverh($nrofac,'2').$vl2;
        $vconnit=$nit.$this->nverh($nit,'2').$vl3;
        $vconfecha=$fecha.$this->nverh($fecha,'2').$vl4;
        $vconmonto=$monto.$this->nverh($monto,'2').$vl5;
        //cadena concatenada
        $cadenaconcatenada=$vconau.$vconfac.$vconnit.$vconfecha.$vconmonto;
        //llave para cifrado
        $llaveparacifrado=$llave.$this->nverh($suma,'5');
        $valorrc4=$this->rc4($cadenaconcatenada, $llaveparacifrado);
        $sumatotal=$this->sumatoria($valorrc4,1,1);
        $sumaparcial1=$this->sumatoria($valorrc4,1,5);
        $sumaparcial2=$this->sumatoria($valorrc4,2,5);
        $sumaparcial3=$this->sumatoria($valorrc4,3,5);
        $sumaparcial4=$this->sumatoria($valorrc4,4,5);
        $sumaparcial5=$this->sumatoria($valorrc4,5,5);
        
        $producto1=($sumatotal*$sumaparcial1)/$v1;
        $producto2=($sumatotal*$sumaparcial2)/$v2;
        $producto3=($sumatotal*$sumaparcial3)/$v3;
        $producto4=($sumatotal*$sumaparcial4)/$v4;
        $producto5=($sumatotal*$sumaparcial5)/$v5;
        $totalproducto=(int)$producto1+(int)$producto2+(int)$producto3+(int)$producto4+(int)$producto5;
        $base64=$this->big_base_convert($totalproducto, "64");
        $base64rc4=$this->rc4guion($base64, $llaveparacifrado);
        return $base64rc4;
    }
    function big_base_convert($numero, $base = "64") {
		$dic = array(
			'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 
			'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 
			'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 
			'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 
			'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 
			'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 
			'y', 'z', '+', '/' );
		$cociente = "1";
		$resto = "";
		$palabra = "";
		while (bccomp($cociente, "0")) {
			$cociente = bcdiv($numero, $base);
			$resto = bcmod($numero, $base);
			$palabra = $dic[0 + $resto] . $palabra;
			$numero = "" . $cociente;
		}
		return $palabra;
	}
    function rc4($mensaje, $llaverc4) {
		$state = array();
		$x = 0;
		$y = 0;
		$index1 = 0;
		$index2 = 0;
		$nmen = 0;
		$i = 0;
		$cifrado = "";
		
		$state = range(0, 255);
		
		$strlen_llave = strlen($llaverc4);
		$strlen_mensaje = strlen($mensaje);
		for ($i = 0; $i < 256; $i++) {
			$index2 = ( ord($llaverc4[$index1]) + $state[$i] + $index2 ) % 256;
			list($state[$i], $state[$index2]) = array($state[$index2], $state[$i]);
			$index1 = ($index1 + 1) % $strlen_llave;
		}
		for ($i = 0; $i < $strlen_mensaje; $i++) {
			$x = ($x + 1) % 256;
			$y = ($state[$x] + $y) % 256;
			list($state[$x], $state[$y]) = array($state[$y], $state[$x]);
			// ^ = XOR function
			$nmen = ord($mensaje[$i]) ^ $state[ ( $state[$x] + $state[$y] ) % 256];
			$cifrado .= substr("0" . $this->big_base_convert($nmen, "16"), -2);
		}
		return $cifrado;
	}
        function rc4guion($mensaje, $llaverc4) {
		$state = array();
		$x = 0;
		$y = 0;
		$index1 = 0;
		$index2 = 0;
		$nmen = 0;
		$i = 0;
		$cifrado = "";
		
		$state = range(0, 255);
		
		$strlen_llave = strlen($llaverc4);
		$strlen_mensaje = strlen($mensaje);
		for ($i = 0; $i < 256; $i++) {
			$index2 = ( ord($llaverc4[$index1]) + $state[$i] + $index2 ) % 256;
			list($state[$i], $state[$index2]) = array($state[$index2], $state[$i]);
			$index1 = ($index1 + 1) % $strlen_llave;
		}
		for ($i = 0; $i < $strlen_mensaje; $i++) {
			$x = ($x + 1) % 256;
			$y = ($state[$x] + $y) % 256;
			list($state[$x], $state[$y]) = array($state[$y], $state[$x]);
			// ^ = XOR function
			$nmen = ord($mensaje[$i]) ^ $state[ ( $state[$x] + $state[$y] ) % 256];
			$cifrado = $cifrado.'-'.substr("0" . $this->big_base_convert($nmen, "16"), -2);
		}
		return substr($cifrado,1);
	}
    
}
/*if(isset($_GET["codigo"])){
  //  generar();
//}
function generar()
{
    $nroau=$_POST["numau"];
    $nrofac=$_POST["numfac"];
    $nit=$_POST["nit"];
    $fecha=$_POST["fecha"];
    $monto=$_POST["monto"];
    $llave=$_POST["llave"];
    $ver= new CodigodeControl;
    $var=$ver->codigoControl($nroau,$nrofac,$nit,$fecha,$monto,$llave);
    echo $var;
}*/
//$ver= new CodigodeControl;
//$var=$ver->nverh('1503','2');
//$var=$ver->verh('15031');
//$var2=$ver->allegedRC4('d3Ir6','sesamo');
//$var2=$ver->allegedRC4('IUKYo', 'XBCPY-GKGX4-PGK44-8B632-X9P33');
//$var=$ver->rc4guion('1904008691195pPg97825622iF047S%)v}@N4W20080201233aQqqXCEH2600627VS2[aD', 'pPgiFS%)v}@N4W3aQqqXCEHVS2[aDw_n%3)pFyU%bEB9)YXt%xNBub4@PZ4S9)ct21885');
//$var=$ver->codigoControl('2904008372149','461448','1708952','2008/04/07','65934,70','9GFdP32EQ]DDmiurUn]ipBirBDr68NxKCznqWYI}bd5YAghuwIW9yJ6IS(hVQxXa');
//$var2=$ver->x11('sesamo','d3Ir6');
//$var3=$ver->big_base_convert(19058106,"64");
//echo($var);
//echo($var2);
//echo($var);

?>